<?php
/*
Plugin Name: Divi Image Hover
Plugin URI:  https://divizoom.com
Description: An Amazing Subtle image hover effects by Divi Module. You can choose image and content effects from 6 different categories like classic, modern, advanced, minimal, Image Swap and Image Lightbox. There are 250+ Hover Effects, Title Text, Content Text, Button, Custom Background, spacing, and many more options.
Version:     2.0.2
Author:      Divizoom
Author URI:  https://divizoom.com
Text Domain: et_builder
Domain Path: /languages
*/
// This file includes code from Main WordPress Formatting API, licensed GPLv2 - https://wordpress.org/about/gpl/

if (!function_exists('dizo_initialize_extension')) :
	/**
	 * Creates the extension's main class instance.
	 *
	 * @since 1.0.0
	 */
	function dizo_initialize_extension()
	{
		require_once plugin_dir_path(__FILE__) . 'includes/DiviImageHover.php';
	}
	add_action('divi_extensions_init', 'dizo_initialize_extension');
endif;

/**
 * Enqueue lightbox styles and scripts file
 * @since 1.3.0
 */

function dizo_scripts() {
	wp_enqueue_style('dizo-lightbox-styles', plugin_dir_url(__FILE__) .  'styles/lightbox.min.css');
// wp_enqueue_script('dizo-lightbox-scripts', plugin_dir_url(__FILE__) . 'scripts/lightbox.min.js' , array('jquery'), '1.0.0', true );
	    
}
add_action( 'wp_enqueue_scripts', 'dizo_scripts' );

// defining the main directory path
define('DZIH_MAIN_DIR', __DIR__);

