<?php
/*
Plugin Name: Dg Blog Module
Plugin URI: https://www.divigear.com/
Description: A blog module for divi theme
Version: 1.0.11
Author: DiviGear
Author URI: https://www.divigear.com/
License: GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: dg-blog-module
Domain Path: /languages
*/

if (!defined('DGBM_MAIN_DIR')) {
	define( "DGBM_MAIN_DIR", __DIR__ );
}
if (!defined('DGBM_VERSION')) {
	define("DGBM_VERSION", '1.0.11');
}

/**
 * Register scripts and styles
 * for Blog module
 * 
 */
function dgbm_scripts(){
    wp_register_script('fitvids', trailingslashit(plugin_dir_url(__FILE__)) . 'scripts/lib/fitvids.js' , array('jquery'), DGBM_VERSION, true );
}
add_action('wp_enqueue_scripts', 'dgbm_scripts');

if ( ! function_exists( 'dgbm_initialize_extension' ) ):
/**
 * Creates the extension's main class instance.
 *
 * @since 1.0.0
 */
function dgbm_initialize_extension() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/DgBlogModule.php';
}
add_action( 'divi_extensions_init', 'dgbm_initialize_extension' );
endif;

// include plugin functions
require_once (__DIR__ . '/includes/functions.php');
// include plugin settings
require_once (__DIR__ . '/core/init.php');
