<?php
if ( ! class_exists( 'ET_Builder_Element' ) ) {
	return;
}
trait DGAT_Background {
    /**
     * add background field
     */
    function dg_add_bg_field( $args = array() )
    {
        $default    = array(
            'label'				=> '',
            'key'               => '',
            'toggle_slug'       => '',
            'sub_toggle'		=> null,
            'tab_slug'			=> '',
            'mobile_options'    => true,
            'hover'				=> 'tabs',
            'color'             => true,
            'gradient'          => true,
            'image'             => true,
            'order_reverse'     => false,
            'show_if'           => null,
            'show_if_not'       => null,
        );
        $args   = wp_parse_args( $args, $default );
        $fields = array();
        $key = $args['key'];

        $_fields = array(
            'label'               => sprintf(esc_html__('%1$s', 'dgat-advanced-tabs'), $args['label']),
            'tab_slug'            => $args['tab_slug'],
            'toggle_slug'         => $args['toggle_slug'],
            'attr_suffix'         => 'df',
            'type'                => 'composite',
            'hover'               => $args['hover'],
            'composite_type'      => 'default',
            'composite_structure' => array(),
            'show_if'             => $args['show_if'],
            'show_if_not'         => $args['show_if_not']
        );

        $background_fields = array();

        if ($args['color'] === true) {
            $background_fields['color'] = array (
                'icon'     => 'background-color',
                'controls' => array(
                    "{$key}_bgcolor" => array(
                        'label' => esc_html__( 'Background Color', 'dgat-advanced-tabs' ),
                        'type'  => 'color-alpha',
                        'hover' => $args['hover'],
                    ),
                ),
            );
        }

        if ($args['gradient'] === true) {
            $background_fields['color_gradient'] = array (
                'icon'     => 'background-gradient',
                'controls' => array(
                    "{$key}_use_gradient" => array(
                        'label'           => esc_html__( 'Use gradient background', 'dgat-advanced-tabs' ),
                        'type'            => 'yes_no_button', 
                        'options'           => array(
                            'on'  => esc_html__( 'On', 'dgat-advanced-tabs' ),
                            'off' => esc_html__( 'Off', 'dgat-advanced-tabs' ),
                        ),
                        'default'   => 'off'
                    ),
                    "{$key}_color_gradient_1" => array(
                        'label' => esc_html__( 'Select color', 'dgat-advanced-tabs' ),
                        'type'  => 'color-alpha',
                        'default'   => "#2b87da",
                        'show_if' => array(
                            "{$key}_use_gradient" => 'on'
                        ),
                        'hover' => $args['hover']
                    ),
                    "{$key}_color_gradient_2" => array(
                        'label' => esc_html__( 'Select color', 'dgat-advanced-tabs' ),
                        'type'  => 'color-alpha',
                        'default'   => "#29c4a9",
                        'show_if' => array(
                            "{$key}_use_gradient" => 'on'
                        ),
                        'hover' => $args['hover']
                    ),
                    "{$key}_gradient_type" => array(
                        'label' => esc_html__( 'Gradient Type', 'dgat-advanced-tabs' ),
                        'type'  => 'select',
                        'options'         => array(
                            'leniar'    => esc_html__( 'Linear', 'dgat-advanced-tabs' ),
                            'radial'    => esc_html__( 'Radial', 'dgat-advanced-tabs' )
                        ),
                        'default'   => 'leniar',
                        'show_if' => array(
                            "{$key}_use_gradient" => 'on'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_radial_direction" => array(
                        'label' => esc_html__( 'Radial Direction', 'dgat-advanced-tabs' ),
                        'type'  => 'select',
                        'options'         => array(
                            'center'    => esc_html__( 'Center', 'dgat-advanced-tabs' ),
                            'top_left'    => esc_html__( 'Top Left', 'dgat-advanced-tabs' ),
                            'top'    => esc_html__( 'Top', 'dgat-advanced-tabs' ),
                            'top_right'    => esc_html__( 'Top Right', 'dgat-advanced-tabs' ),
                            'right'    => esc_html__( 'Right', 'dgat-advanced-tabs' ),
                            'bottom_right'    => esc_html__( 'Bottom Right', 'dgat-advanced-tabs' ),
                            'bottom'    => esc_html__( 'Bottom', 'dgat-advanced-tabs' ),
                            'bottom_left'    => esc_html__( 'Bottom Left', 'dgat-advanced-tabs' ),
                            'left'    => esc_html__( 'Left', 'dgat-advanced-tabs' ),
                        ),
                        'default'   => 'center',
                        'show_if' => array(
                            "{$key}_use_gradient" => 'on',
                            "{$key}_gradient_type" => 'radial'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_gradient_direction" => array(
                        'label'             => esc_html__( 'Gradient Direction', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '180deg',
                        'default_on_front'  => '',
                        'default_unit'      => 'deg',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '360',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_use_gradient" => 'on'
                        ),
                        'show_if_not'       => array(
                            "{$key}_gradient_type" => 'radial'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_start_position" => array(
                        'label'           => esc_html__( 'Start Position', 'dgat-advanced-tabs' ),
                        'type'            => 'range', 
                        'default'   => '0%',
                        'show_if' => array(
                            "{$key}_use_gradient" => 'on'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_end_position" => array(
                        'label'           => esc_html__( 'End Position', 'dgat-advanced-tabs' ),
                        'type'            => 'range', 
                        'default'   => '100%',
                        'show_if' => array(
                            "{$key}_use_gradient" => 'on'
                        ),
                        'hover'  => $args['hover'],
                    )
                )
            );

            if ($args['image'] === true){
                $background_fields['color_gradient']['controls']["{$key}_above_image"] =  array(
                    'label'           => esc_html__( 'Place Gradiet Above Background Image', 'dgat-advanced-tabs' ),
                    'type'            => 'yes_no_button', 
                    'options'           => array(
                        'on'  => esc_html__( 'On', 'dgat-advanced-tabs' ),
                        'off' => esc_html__( 'Off', 'dgat-advanced-tabs' ),
                    ),
                    'show_if' => array(
                        "{$key}_use_gradient" => 'on'
                    )
                );
            }
            
        }

        if ($args['image'] === true) {
            $background_fields['image'] = array (
                'icon'     => 'background-image',
                'controls' => array(
                    "{$key}_background_image" => array(
                        'label' => esc_html__( 'Background Image', 'dgat-advanced-tabs' ),
                        'type'  => 'upload',
                        'upload_button_text' => esc_attr__( 'Set Image', 'dgat-advanced-tabs' ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_background_image_size" => array(
                        'label' => esc_html__( 'Background Image Size', 'dgat-advanced-tabs' ),
                        'type'  => 'select',
                        'options'         => array(
                            'cover'    => esc_html__( 'Cover', 'dgat-advanced-tabs' ),
                            'fit'    => esc_html__( 'Fit', 'dgat-advanced-tabs' ),
                            'actual_size'    => esc_html__( 'Actual Size', 'dgat-advanced-tabs' ),
                            'custom'    => esc_html__('Custom Size', 'dgat-advanced-tabs')
                        ),
                        'default'   => 'cover',
                        'hover' => $args['hover'],
                    ),
                    "{$key}_size_width" => array(
                        'label'             => esc_html__( 'Background Width', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '50%',
                        'default_on_front'  => '',
                        'default_unit'      => '%',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '100',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_size" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_size_height" => array(
                        'label'             => esc_html__( 'Background Height', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '50%',
                        'default_on_front'  => '',
                        'default_unit'      => '%',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '100',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_size" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_size_width" => array(
                        'label'             => esc_html__( 'Background Width', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '50%',
                        'default_on_front'  => '',
                        'default_unit'      => '%',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '100',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_size" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_size_height" => array(
                        'label'             => esc_html__( 'Background Height', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '50%',
                        'default_on_front'  => '',
                        'default_unit'      => '%',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '100',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_size" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_background_image_position" => array(
                        'label' => esc_html__( 'Background Image Position', 'dgat-advanced-tabs' ),
                        'type'  => 'select',
                        'options'         => array(
                            'top_left'    => esc_html__( 'Top Left', 'dgat-advanced-tabs' ),
                            'top_center'    => esc_html__( 'Top Center', 'dgat-advanced-tabs' ),
                            'top_right'    => esc_html__( 'Top Right', 'dgat-advanced-tabs' ),
                            'center_left'    => esc_html__( 'Center Left', 'dgat-advanced-tabs' ),
                            'center'    => esc_html__( 'Center', 'dgat-advanced-tabs' ),
                            'center_right'    => esc_html__( 'Center Right', 'dgat-advanced-tabs' ),
                            'bottom_left'    => esc_html__( 'Bottom Left', 'dgat-advanced-tabs' ),
                            'bottom_center'    => esc_html__( 'Bottom Center', 'dgat-advanced-tabs' ),
                            'bottom_right'    => esc_html__( 'Bottom Right', 'dgat-advanced-tabs' ),
                            'custom'          => esc_html__('Custom Position', 'dgat-advanced-tabs')
                        ),
                        'default'   => 'center',
                        'hover' => $args['hover'],
                    ),
                    "{$key}_position_horizontal" => array(
                        'label'             => esc_html__( 'Horizontal Position', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '0px',
                        'default_on_front'  => '',
                        'default_unit'      => 'px',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '1000',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_position" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_position_vertical" => array(
                        'label'             => esc_html__( 'Vertical Position', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '0px',
                        'default_on_front'  => '',
                        'default_unit'      => 'px',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '1000',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_position" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_position_horizontal" => array(
                        'label'             => esc_html__( 'Horizontal Position', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '0px',
                        'default_on_front'  => '',
                        'default_unit'      => 'px',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '1000',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_position" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_position_vertical" => array(
                        'label'             => esc_html__( 'Vertical Position', 'dgat-advanced-tabs' ),
                        'type'              => 'range', 
                        'default'           => '0px',
                        'default_on_front'  => '',
                        'default_unit'      => 'px',
                        'range_settings'         => array(
                            'min'    => '0',
                            'max'    => '1000',
                            'step'    => '1'
                        ),
                        'show_if'           => array(
                            "{$key}_background_image_position" => 'custom'
                        ),
                        'hover'  => $args['hover'],
                    ),
                    "{$key}_background_image_repeat" => array(
                        'label' => esc_html__( 'Background Image Repeat', 'dgat-advanced-tabs' ),
                        'type'  => 'select',
                        'options'         => array(
                            'no_repeat'    => esc_html__( 'No Repeat', 'dgat-advanced-tabs' ),
                            'repeat'    => esc_html__( 'Repeat', 'dgat-advanced-tabs' ),
                            'repeat_x'    => esc_html__( 'Repeat X (horizontal)', 'dgat-advanced-tabs' ),
                            'repeat_y'    => esc_html__( 'Repeat Y (vertical)', 'dgat-advanced-tabs' ),
                            'space'    => esc_html__( 'Space', 'dgat-advanced-tabs' ),
                            'round'    => esc_html__( 'Round', 'dgat-advanced-tabs' ),
                        ),
                        'default'   => 'no_repeat',
                        'hover' => $args['hover'],
                    )
                ),
            );
        }
        if ($args['order_reverse'] === true) {
            $background_fields = array_reverse($background_fields);
        }
        
        $_fields['composite_structure'] = $background_fields;

        $fields[$args['key']] = $_fields;

        return $fields;
    }
}