<?php
require_once(DZIH_MAIN_DIR . '/functions/utls.php');
class DIZO_ImageHover extends ET_Builder_Module
{

	public $slug       = 'dizo_image_hover';
	public $vb_support = 'on';
	use Dz_utls;

	protected $module_credits = array(
		'module_uri' => 'https://divizoom.com',
		'author'     => 'Divizoom',
		'author_uri' => 'https://divizoom.com',
	);

	public function init()
	{
		$this->name = esc_html__('Divi Image Hover', 'et_builder');
		$this->main_css_element = '%%order_class%%';
		$this->settings_modal_toggles = array(
			'general' => array(
				'toggles' => array(
					'minimal_effect_color' => esc_html__('Minimal Effect Color','et_builder'),
					'upload_img' => esc_html__('Image', 'et_builder'),
					'content' => esc_html__('Content', 'et_builder'),
					'button'	=> esc_html__('Button', 'et_builder'),
					'link'		=> array(
						'title' => esc_html__('Link', 'et_builder'),
						'priority' => 99
					),
					'image_overlay' => esc_html__('Image Overlay', 'et_builder'),
					'content_wrapper_bg' => esc_html__('Content Background', 'et_builder'),
					'swap_image' => esc_html__('Swap Effect', 'et_builder'),
					'lightbox' => esc_html__('Image Lightbox','et_builder')
					
				)
			),
			'advanced' => array(
				'toggles' => array(
					'effect' => esc_html__('Hover Effect', 'et_builder'),
					'title'				=> esc_html__('Title', 'et_builder'),
					'title_prefix'		=> esc_html__('Title Prefix', 'et_builder'),
					'title_infix'		=> esc_html__('Title Infix', 'et_builder'),
					'title_suffix'		=> esc_html__('Title Suffix', 'et_builder'),
					'content'			=> esc_html__('Content', 'et_builder'),
					'image'				=> esc_html__('Image', 'et_builder'),
					'button_settings'	=> esc_html__('Button', 'et_builder'),
					'custom_borders'	=> esc_html__('Custom Borders', 'et_builder'),
					'custom_spacing'	=> array(
						'title'				=> esc_html__('Custom Spacing', 'et_builder'),
						'tabbed_subtoggles'	=> true,
						'sub_toggles'		=> array(
							'container'		=> array(
								'name'		=> esc_html__('Container', 'et_builder'),
							),
							'title'			=> array(
								'name'		=> esc_html__('Title', 'et_builder'),
							),
							'text'		=> array(
								'name'		=> esc_html__('Text', 'et_builder'),
							),

						),
					),

				),
			),
			'custom_css' => array(
				'toggles' => array(
					'animation' => array(
						'title'    => esc_html__('Animation', 'et_builder'),
						'priority' => 90,
					),
					'attributes' => array(
						'title'    => esc_html__('Attributes', 'et_builder'),
						'priority' => 95,
					),
				),
			),
		);
	}
	public function get_advanced_fields_config()
	{
		$advanced_fields = array();
		$advanced_fields['fonts'] = array(
			'title'   => array(
				'label'         => esc_html__('Title', 'et_builder'),
				'toggle_slug'   => 'title',
				'tab_slug'		=> 'advanced',
				'line_height' => array(
					'default' => '1em',
				),
				'font_size' => array(
					'default' => '18px',
				),
				'css'      => array(
					'main' => "{$this->main_css_element} .dih_title,
                                {$this->main_css_element} .dih_title span",
					'hover' => "{$this->main_css_element}:hover .dih_title,
                                {$this->main_css_element}:hover .dih_title span",

					'important' => 'all',
				),
				'plugn_main'	=> "{$this->main_css_element} .dih_title",

				'header_level'	=> array(
					'default'	=> 'h2',
				),
			),

			'title_prefix'	=> array(
				'label'				=> esc_html__('Title Prefix', 'et_builder'),
				'css'      			=> array(
					'main'        	=> "{$this->main_css_element} .dih_title span.prefix",
					'hover' 		=> "{$this->main_css_element}:hover .dih_title span.prefix",
					'font'			=> "{$this->main_css_element} .dih_title span.prefix",
					'color'       	=> "{$this->main_css_element} .dih_title span.prefix",
					'line_height' 	=> "{$this->main_css_element} .dih_title span.prefix",
					'important'		=> 'all',

				),

				'line_height' 		=> array(
					'default' 		=> '1em',
				),
				'font_size' => array(
					'default' 		=> '18px',
				),
				'toggle_slug' 		=> 'title_prefix',
			),
			'title_infix'	=> array(
				'label'				=> esc_html__('Title Infix', 'et_builder'),
				'css'      			=> array(
					'main'        	=> "{$this->main_css_element} .dih_title span.infix",
					'hover' 		=> "{$this->main_css_element}:hover .dih_title span.infix",
					'font'			=> "{$this->main_css_element} .dih_title span.infix",
					'color'       	=> "{$this->main_css_element} .dih_title span.infix",
					'line_height' 	=> "{$this->main_css_element} .dih_title span.infix",
					'important'		=> 'all',

				),

				'line_height' 		=> array(
					'default' 		=> '1em',
				),
				'font_size' => array(
					'default' 		=> '18px',
				),
				'toggle_slug' 		=> 'title_infix',
			),
			'title_suffix'	=> array(
				'label'				=> esc_html__('Title suffix', 'et_builder'),
				'css'      			=> array(
					'main'        	=> "{$this->main_css_element} .dih_title span.suffix",
					'hover' 		=> "{$this->main_css_element}:hover .dih_title span.suffix",
					'font'			=> "{$this->main_css_element} .dih_title span.suffix",
					'color'       	=> "{$this->main_css_element} .dih_title span.suffix",
					'line_height' 	=> "{$this->main_css_element} .dih_title span.suffix",
					'important'		=> 'all',
				),

				'line_height' 		=> array(
					'default' 		=> '1em',
				),
				'font_size' => array(
					'default' 		=> '18px',
				),
				'toggle_slug' 		=> 'title_suffix',
				'tab_slug'			=> 'advanced'
			),
			'content'	=> array(
				'label'				=> esc_html__('Content', 'et_builder'),
				'css'      			=> array(
					'main'        	=> "{$this->main_css_element} .dih_img_wrapper .dih_content_wrapper .dih_content .dih_text, 
					{$this->main_css_element} .dih_img_wrapper .dih_content_wrapper .dih_content .dih_text p, 
					{$this->main_css_element} .dih_img_wrapper .dih_text h1,
					{$this->main_css_element} .dih_img_wrapper .dih_text h2,
					{$this->main_css_element} .dih_img_wrapper .dih_text h3,
					{$this->main_css_element} .dih_img_wrapper .dih_text h4,
					{$this->main_css_element} .dih_img_wrapper .dih_text h5,
					{$this->main_css_element} .dih_img_wrapper .dih_text h6",

					'hover' 		=> "{$this->main_css_element} .dih_img_wrapper:hover .dih_content_wrapper .dih_content .dih_text, 
					{$this->main_css_element} .dih_img_wrapper:hover .dih_content_wrapper .dih_content .dih_text p, 
					{$this->main_css_element} .dih_img_wrapper:hover .dih_text h1, 
					{$this->main_css_element} .dih_img_wrapper:hover .dih_text h2,
					{$this->main_css_element} .dih_img_wrapper:hover .dih_text h3,
					{$this->main_css_element} .dih_img_wrapper:hover .dih_text h4,
					{$this->main_css_element} .dih_img_wrapper:hover .dih_text h5,
					{$this->main_css_element} .dih_img_wrapper:hover .dih_text h6",
					// 'font'			=> "{$this->main_css_element} .dih_img_wrapper .dih_text, {$this->main_css_element} .dih_img_wrapper .dih_text p",
					// 'color'       	=> "{$this->main_css_element} .dih_img_wrapper .dih_text, {$this->main_css_element} .dih_img_wrapper .dih_text p",
					// 'line_height' 	=> "{$this->main_css_element} .dih_img_wrapper .dih_text, {$this->main_css_element} .dih_img_wrapper .dih_text p",
					'important'		=> 'all',
				),

				'line_height' 		=> array(
					'default' 		=> '1em',
				),
				'font_size' => array(
					'default' 		=> '18px',
				),
				'toggle_slug' 		=> 'content',
			),
		);
		$advanced_fields['borders'] = array(
			'default'               => array(),
			'title_border' => array(
				'css'               => array(
					'main'  => array(
						'border_radii' => "{$this->main_css_element} .dih_img_wrapper .dih_title, 
						{$this->main_css_element} .dih_img_wrapper.mdn-elisha .dih_title",
						'border_styles' => "{$this->main_css_element} .dih_img_wrapper .dih_title, 
							{$this->main_css_element} .dih_img_wrapper.mdn-elisha .dih_title",
						'border_styles_hover' => "{$this->main_css_element} .dih_img_wrapper:hover .dih_title, 
							{$this->main_css_element} .dih_img_wrapper.mdn-elisha:hover .dih_title",
					)
				),
				'label_prefix'    => esc_html__('Title', 'et_builder'),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'custom_borders',
			),
			'content_border' => array(
				'css'               => array(
					'main'  => array(
						'border_radii' => "{$this->main_css_element} .dih_img_wrapper .dih_text, 
						{$this->main_css_element} .dih_img_wrapper.mdn-elisha .dih_text",
						'border_styles' => "{$this->main_css_element} .dih_img_wrapper .dih_text, 
						{$this->main_css_element} .dih_img_wrapper.mdn-elisha .dih_text	",
						'border_styles_hover' => "{$this->main_css_element} .dih_img_wrapper:hover .dih_text, 
						{$this->main_css_element} .dih_img_wrapper.mdn-elisha:hover .dih_text"
					)
				),
				'label_prefix'    => esc_html__('Content', 'et_builder'),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'custom_borders',
				'important'		=> 'all'
			),
	
			'prefix_border'         => array(
				'css'               => array(
					'main'  => array(
						'border_radii' => "{$this->main_css_element} .dih_img_wrapper span.prefix",
						'border_styles' => "{$this->main_css_element} .dih_img_wrapper span.prefix",
						'border_styles_hover' => "{$this->main_css_element} .dih_img_wrapper:hover span.prefix",
					)
				),
				'label_prefix'    => esc_html__('Prefix', 'et_builder'),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'custom_borders',
				'important'		=> 'all'
			),
			'infix_border'         => array(
				'css'               => array(
					'main'  => array(
						'border_radii' => "{$this->main_css_element} .dih_img_wrapper span.infix",
						'border_styles' => "{$this->main_css_element} .dih_img_wrapper span.infix",
						'border_styles_hover' => "{$this->main_css_element} .dih_img_wrapper:hover span.infix",
					)
				),
				'label_prefix'    => esc_html__('Infix', 'et_builder'),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'custom_borders',
				'important'		=> 'all'
			),
			'suffix_border'         => array(
				'css'               => array(
					'main'  => array(
						'border_radii' => "{$this->main_css_element} .dih_img_wrapper span.suffix",
						'border_styles' => "{$this->main_css_element} .dih_img_wrapper span.suffix",
						'border_styles_hover' => "{$this->main_css_element} .dih_img_wrapper:hover span.suffix",
					)
				),
				'label_prefix'    => esc_html__('Suffix', 'et_builder'),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'custom_borders',
				'important'		=> 'all'
			),

			'image_border'         => array(
				'css'               => array(
					'main'  => array(
						'border_radii' => "{$this->main_css_element} .dih_img_wrapper",
						'border_styles' => "{$this->main_css_element} .dih_img_wrapper",
						'border_styles_hover' => "{$this->main_css_element} .dih_img_wrapper:hover",
					)
				),
				'label_prefix'    => esc_html__('Image', 'et_builder'),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'image',
				'important'		=> 'all',
				
			)
		);

		$advanced_fields['box_shadow'] = array(
			'default'               => array(
				'css' => array(
					'main' => "{$this->main_css_element} .dih_img_wrapper",
					'hover' => "{$this->main_css_element} .dih_img_wrapper:hover",
				),
			),
			'title'             => array(
				'css' => array(
					'main' => "{$this->main_css_element} .dih_img_wrapper .dih_title",
					'hover' => "{$this->main_css_element} .dih_img_wrapper:hover .dih_title",
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'title',
				'label_prefix'    => esc_html__('Title', 'et_builder'),
				'important'		=> 'all',

			),
			'prefix'             => array(
				'css' => array(
					'main' => "{$this->main_css_element} .dih_img_wrapper span.prefix",
					'hover' => "{$this->main_css_element} .dih_img_wrapper:hover span.prefix",
					'important'		=> 'all',
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'title_prefix',
				
			),
			'infix'             => array(
				'css' => array(
					'main' => "{$this->main_css_element} .dih_img_wrapper span.infix",
					'hover' => "{$this->main_css_element} .dih_img_wrapper:hover span.infix",
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'title_infix',
				'important'		=> 'all',
			),
			'suffix'             => array(
				'css' => array(
					'main' => "{$this->main_css_element} .dih_img_wrapper span.suffix",
					'hover' => "{$this->main_css_element} .dih_img_wrapper:hover span.suffix",
				),
				'tab_slug'        => 'advanced',
				'toggle_slug'     => 'title_suffix',
				'important'		=> 'all',
			)
		);
		$advanced_fields['background'] = array(
			'css' => array(
				'main' => "{$this->main_css_element} .dih_img_wrapper",
				'hover' => "{$this->main_css_element} .dih_img_wrapper:hover",
				'important'		=> 'all'
			)
		);
		$advanced_fields['button'] = array(
			'button' => array(
				'label' => esc_html__('Button', 'et_builder'),
				'css'   => array(
					'main'		=> "{$this->main_css_element} .dih_img_wrapper .et_pb_button",
					'alignment'   => "{$this->main_css_element} .dih_img_wrapper .et_pb_button_wrapper",
				),
				'box_shadow' => array(
					'main'		=> "{$this->main_css_element} .dih_img_wrapper .et_pb_button",
				),
				'toggle_slug' => 'button_settings',
				'use_alignment'	=> false,
				'box_shadow' => false
			),
		);
		$advanced_fields['max_width'] = array(
			'max_width'		=> array(
				'css'	=> array(
					'main'	=> "{$this->main_css_element} .dih_img_wrapper"
				)
			)
		);

		$advanced_fields['height'] = array(
			'css' => array(
				'main' => "{$this->main_css_element} .dih_img_wrapper",
			),
		);
		$advanced_fields['text'] = false;
		$advanced_fields['filters'] = false;
		$advanced_fields['link_options'] = false;


		return $advanced_fields;
	}

	public function get_custom_css_fields_config()
	{
		$custom_css = array();

		$custom_css['wrapper'] = array(
			'label'    => esc_html__('Wrapper', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper',
		);
		$custom_css['title'] = array(
			'label'    => esc_html__('Title', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_title',
		);
		$custom_css['title_before'] = array(
			'label'    => esc_html__('Title Before', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_title:before',
		);
		$custom_css['title_after'] = array(
			'label'    => esc_html__('Title After', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_title:after',
		);
		$custom_css['prefix'] = array(
			'label'    => esc_html__('Prefix', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_title .prefix',
		);
		$custom_css['infix'] = array(
			'label'    => esc_html__('Infix', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_title .infix',
		);
		$custom_css['suffix'] = array(
			'label'    => esc_html__('Suffix', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_title .suffix',
		);
		$custom_css['text'] = array(
			'label'    => esc_html__('Text', 'et_builder'),
			'selector' => ' %%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content .dih_text',
		);
		$custom_css['text_wrapper'] = array(
			'label'    => esc_html__('Text Wrapper', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content',
		);
		$custom_css['content_wrapper'] = array(
			'label'    => esc_html__('Content Wrapper', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper',
		);
		$custom_css['content_wrapper_before'] = array(
			'label'    => esc_html__('Content Wrapper Before', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper:before',
		);
		$custom_css['content_wrapper_after'] = array(
			'label'    => esc_html__('Content Wrapper After', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper:after',
		);
		$custom_css['image'] = array(
			'label'    => esc_html__('Image', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_image img',
		);
		$custom_css['button'] = array(
			'label'    => esc_html__('Button', 'et_builder'),
			'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_button',
		);

		return $custom_css;
	}
	public function get_fields()
	{
		$effect = array(
			'effect_style' => array(
				'default'		=> 'default',
				'label'			=> esc_html__('Hover Effect Style', 'et_builder'),
				'type'			=> 'select',
				'options'		=> array(
					'default'	=> esc_html__('Default', 'et_builder'),
					'classic' 	=> esc_html__('Classic', 'et_builder'),
					'modern' 	=> esc_html__('Modern', 'et_builder'),
					'adv' 		=> esc_html__('Advanced', 'et_builder'),
					'minimal' 	=> esc_html__('Minimal','et_builder')
					
				),
				'toggle_slug'	=> 'effect',
				'tab_slug'      => 'advanced',
				'show_if' => array(
					'swap' => 'off'
				)
			),
			'classic_style' => array(
				'default'         => 'dzhvr-fade-in-up',
				'label'           => esc_html__('Classic Hover Style', 'et_builder'),
				'type'            => 'select',
				'options'         => array(
					'dzhvr-fade-in-up' => esc_html__('Fade In Up', 'et_builder'),
					'dzhvr-fade-in-down' => esc_html__('Fade In Down', 'et_builder'),
					'dzhvr-fade-in-left' => esc_html__('Fade In Left', 'et_builder'),
					'dzhvr-fade-in-right' => esc_html__('Fade In Right', 'et_builder'),
					'dzhvr-push-up' => esc_html__('Push Up', 'et_builder'),
					'dzhvr-push-down' => esc_html__('Push Down', 'et_builder'),
					'dzhvr-push-left' => esc_html__('Push Left', 'et_builder'),
					'dzhvr-push-right' => esc_html__('Push Right', 'et_builder'),
					'dzhvr-slide-up' => esc_html__('Slide Up', 'et_builder'),
					'dzhvr-slide-down' => esc_html__('Slide Down', 'et_builder'),
					'dzhvr-slide-left' => esc_html__('Slide Left', 'et_builder'),
					'dzhvr-slide-right' => esc_html__('Slide Right', 'et_builder'),
					'dzhvr-slide-top-left' => esc_html__('Slide Top Left', 'et_builder'),
					'dzhvr-slide-top-right' => esc_html__('Slide Top Right', 'et_builder'),
					'dzhvr-slide-bottom-left' => esc_html__('Slide Bottom Left', 'et_builder'),
					'dzhvr-slide-bottom-right' => esc_html__('Slide Bottom Right', 'et_builder'),
					'dzhvr-reveal-up' => esc_html__('Reveal Up', 'et_builder'),
					'dzhvr-reveal-down' => esc_html__('Reveal Down', 'et_builder'),
					'dzhvr-reveal-left' => esc_html__('Reveal Left', 'et_builder'),
					'dzhvr-reveal-right' => esc_html__('Reveal Right', 'et_builder'),
					'dzhvr-reveal-top-left' => esc_html__('Reveal Top Left', 'et_builder'),
					'dzhvr-reveal-top-right' => esc_html__('Reveal Top Right', 'et_builder'),
					'dzhvr-reveal-bottom-left' => esc_html__('Reveal Bottom Left', 'et_builder'),
					'dzhvr-reveal-bottom-right' => esc_html__('Reveal Bottom Right', 'et_builder'),
					'dzhvr-hinge-up' => esc_html__('Hinge Up', 'et_builder'),
					'dzhvr-hinge-down' => esc_html__('Hinge Down', 'et_builder'),
					'dzhvr-hinge-left' => esc_html__('Hinge Left', 'et_builder'),
					'dzhvr-hinge-right' => esc_html__('Hinge Right', 'et_builder'),
					'dzhvr-flip-horiz' => esc_html__('Flip Horizontal', 'et_builder'),
					'dzhvr-flip-vert' => esc_html__('Flip Vertical', 'et_builder'),
					'dzhvr-flip-diag-1' => esc_html__('Flip Diagonal 1 ', 'et_builder'),
					'dzhvr-flip-diag-2' => esc_html__('Flip Diagonal 2 ', 'et_builder'),
					'dzhvr-shutter-out-horiz' => esc_html__('Shutter Out Horizontal', 'et_builder'),
					'dzhvr-shutter-out-vert' => esc_html__('Shutter Out Vertical', 'et_builder'),
					'dzhvr-shutter-out-diag-1' => esc_html__('Shutter Out Diagonal 1', 'et_builder'),
					'dzhvr-shutter-out-diag-2' => esc_html__('Shutter Out Diagonal 2', 'et_builder'),
					'dzhvr-shutter-in-horiz' => esc_html__('Shutter In Horizontal', 'et_builder'),
					'dzhvr-shutter-in-vert' => esc_html__('Shutter In Vertical', 'et_builder'),
					'dzhvr-shutter-in-out-horiz' => esc_html__('Shutter In Out Horizontal', 'et_builder'),
					'dzhvr-shutter-in-out-vert' => esc_html__('Shutter In Out vertical', 'et_builder'),
					'dzhvr-shutter-in-out-diag-1' => esc_html__('Shutter In Out Diagonal 1', 'et_builder'),
					'dzhvr-shutter-in-out-diag-2' => esc_html__('Shutter In Out Diagonal 2', 'et_builder'),
					'dzhvr-fold-up ' => esc_html__('Fold Up', 'et_builder'),
					'dzhvr-fold-down' => esc_html__('Fold Down', 'et_builder'),
					'dzhvr-fold-left' => esc_html__('Fold Left', 'et_builder'),
					'dzhvr-fold-right' => esc_html__('Fold Right', 'et_builder'),
					'dzhvr-zoom-in' => esc_html__('Zoom In', 'et_builder'),
					'dzhvr-zoom-out' => esc_html__('Zoom Out', 'et_builder'),
					'dzhvr-zoom-out-up' => esc_html__('Zoom Out Up', 'et_builder'),
					'dzhvr-zoom-out-down' => esc_html__('Zoom Out Down', 'et_builder'),
					'dzhvr-zoom-out-left' => esc_html__('Zoom Out Left', 'et_builder'),
					'dzhvr-zoom-out-right' => esc_html__('Zoom Out Right', 'et_builder'),
					'dzhvr-zoom-out-flip-horiz' => esc_html__('Zoom Out Flip Horizontal', 'et_builder'),
					'dzhvr-zoom-out-flip-vert' => esc_html__('Zoom Out Flip Vertical', 'et_builder'),
					'dzhvr-blur' => esc_html__('Blur', 'et_builder'),
					'dzhvr-blocks-rotate-left' => esc_html__('Blocks Rotate Left', 'et_builder'),
					'dzhvr-blocks-rotate-right' => esc_html__('Blocks Rotate Right', 'et_builder'),
				),
				'toggle_slug'     => 'effect',
				'tab_slug'          => 'advanced',
				'description'     => esc_html__('Classic Image hover style', 'et_builder'),
				'show_if' => array(
					'effect_style' => 'classic',
					'swap'	=> 'off'
				)
			),
			'modern_style' => array(
				'default'         => 'mdn-elisha',
				'label'           => esc_html__('Modern Hover Style', 'et_builder'),
				'type'            => 'select',
				'options'         => array(
					'mdn-elisha' => esc_html__('Elisha', 'et_builder'),
					'mdn-sarah' => esc_html__('Sarah', 'et_builder'),
					'mdn-malin' => esc_html__('Malin', 'et_builder'),
					'mdn-grace' => esc_html__('Grace', 'et_builder'),
					'mdn-margot' => esc_html__('Margot', 'et_builder'),
					'mdn-meryl' => esc_html__('Meryl', 'et_builder'),
					'mdn-layla' => esc_html__('Layla', 'et_builder'),
					'mdn-bette' => esc_html__('Bette', 'et_builder'),
					'mdn-ingrid' => esc_html__('Ingrid', 'et_builder'),
					'mdn-marley' => esc_html__('Marley', 'et_builder'),
					'mdn-olivia' => esc_html__('Olivia', 'et_builder'),
					'mdn-audrey' => esc_html__('Audrey', 'et_builder'),
					'mdn-susan' => esc_html__('Susan', 'et_builder'),
					'mdn-ruby' => esc_html__('Ruby', 'et_builder'),
					'mdn-sanorita' => esc_html__('Sanorita', 'et_builder'),
					'mdn-chico'		=> esc_html__('Chico', 'et_builder'),
					'mdn-milo'		=> esc_html__('Milo', 'et_builder'),
					'mdn-lexi'		=> esc_html__('Lexi', 'et_builder'),
					'mdn-selena' => esc_html__('Selena', 'et_builder')

				),
				'toggle_slug'     => 'effect',
				'tab_slug'          => 'advanced',
				'description'     => esc_html__('Modern Image hover style', 'et_builder'),
				'show_if' => array(
					'effect_style' => 'modern',
					'swap' => 'off'
				)
			),
			'advanced_style' => array(
				'default'         => 'dzhvr-blocks-rotate-in-left',
				'label'           => esc_html__('Advanced Hover Style', 'et_builder'),
				'type'            => 'select',
				'options'         => array(
					'dzhvr-blocks-rotate-in-left' => esc_html__('Blocks Rotate In Left', 'et_builder'),
					'dzhvr-blocks-rotate-in-right' => esc_html__('Blocks Rotate In Right', 'et_builder'),
					'dzhvr-blocks-in' => esc_html__('Blcoks In', 'et_builder'),
					'dzhvr-blocks-out' => esc_html__('Blocks Out', 'et_builder'),
					'dzhvr-blocks-float-up' => esc_html__('Blocks Float Up', 'et_builder'),
					'dzhvr-blocks-float-down' => esc_html__('Blocks Float Down', 'et_builder'),
					'dzhvr-blocks-float-left' => esc_html__('Blocks Float Left', 'et_builder'),
					'dzhvr-blocks-float-right' => esc_html__('Blocks Float Right', 'et_builder'),
					'dzhvr-blocks-zoom-top-left' => esc_html__('Blocks Zoom Top Left', 'et_builder'),
					'dzhvr-blocks-zoom-top-right' => esc_html__('Blocks Zoom Top Right', 'et_builder'),
					'dzhvr-blocks-zoom-bottom-left' => esc_html__('Blocks Zoom Bottom Left', 'et_builder'),
					'dzhvr-blocks-zoom-bottom-right' => esc_html__('Blocks Zoom Bottom Right', 'et_builder'),
					'dzhvr-strip-shutter-up' => esc_html__('Strip Shutter Up', 'et_builder'),
					'dzhvr-strip-shutter-down' => esc_html__('Strip Shutter Down', 'et_builder'),
					'dzhvr-strip-shutter-left' => esc_html__('Strip Shutter Left', 'et_builder'),
					'dzhvr-strip-shutter-right' => esc_html__('Strip Shutter Right', 'et_builder'),
					'dzhvr-strip-horiz-up' => esc_html__('Strip Horizontal Up', 'et_builder'),
					'dzhvr-strip-horiz-down' => esc_html__('Strip Horizontal Down', 'et_builder'),
					'dzhvr-strip-horiz-top-left' => esc_html__('Strip Horizontal Top Left', 'et_builder'),
					'dzhvr-strip-horiz-top-right' => esc_html__('Strip Horizontal Top Right', 'et_builder'),
					'dzhvr-strip-horiz-bottom-left' => esc_html__('Strip Horizontal Bottom Left', 'et_builder'),
					'dzhvr-strip-horiz-bottom-right' => esc_html__('Strip Horizontal Bottom Right', 'et_builder'),
					'dzhvr-strip-vert-left' => esc_html__('Strip Vertical Left', 'et_builder'),
					'dzhvr-strip-vert-right' => esc_html__('Strip Vertical Right', 'et_builder'),
					'dzhvr-strip-vert-top-left' => esc_html__('Strip Vertical Top Left', 'et_builder'),
					'dzhvr-strip-vert-top-right' => esc_html__('Strip Vertical Top Right', 'et_builder'),
					'dzhvr-strip-vert-bottom-left' => esc_html__('Strip Vertical Bottom Left', 'et_builder'),
					'dzhvr-strip-vert-bottom-right' => esc_html__('Strip Vertical Bottom Right', 'et_builder'),
					'dzhvr-pixel-up' => esc_html__('Pixel Up', 'et_builder'),
					'dzhvr-pixel-down' => esc_html__('Pixel Down', 'et_builder'),
					'dzhvr-pixel-left' => esc_html__('Pixel Left ', 'et_builder'),
					'dzhvr-pixel-right' => esc_html__('Pixel Right ', 'et_builder'),
					'dzhvr-pixel-top-left' => esc_html__('Pixel Top Left', 'et_builder'),
					'dzhvr-pixel-top-right' => esc_html__('Pixel Top Right', 'et_builder'),
					'dzhvr-pixel-bottom-left' => esc_html__('Pixel Bottom Left', 'et_builder'),
					'dzhvr-pixel-bottom-right' => esc_html__('Pixel Bottom Right', 'et_builder'),
					'dzhvr-pivot-in-top-left' => esc_html__('Pivot In Top Left', 'et_builder'),
					'dzhvr-pivot-in-top-right' => esc_html__('Pivot In Top Right', 'et_builder'),
					'dzhvr-pivot-in-bottom-left' => esc_html__('Pivot In Bottom Left', 'et_builder'),
					'dzhvr-pivot-out-top-left' => esc_html__('Pivot Out Top Left', 'et_builder'),
					'dzhvr-pivot-out-top-right' => esc_html__('Pivot Out Top Right', 'et_builder'),
					'dzhvr-pivot-out-bottom-left' => esc_html__('Pivot Out Bottom Left', 'et_builder'),
					'dzhvr-pivot-out-bottom-right ' => esc_html__('Pivot Out Bottom Right', 'et_builder'),
					'dzhvr-throw-in-up' => esc_html__('Throw In up', 'et_builder'),
					'dzhvr-throw-in-down' => esc_html__('Throw In Down', 'et_builder'),
					'dzhvr-throw-in-left' => esc_html__('Throw In Left', 'et_builder'),
					'dzhvr-throw-in-right' => esc_html__('Throw In Right', 'et_builder'),
					'dzhvr-throw-out-up' => esc_html__('Throw Out Up', 'et_builder'),
					'dzhvr-throw-out-down' => esc_html__('Throw Out Down', 'et_builder'),
					'dzhvr-throw-out-left' => esc_html__('Throw Out Left', 'et_builder'),
					'dzhvr-throw-out-right' => esc_html__('Throw Out Right', 'et_builder'),
					'dzhvr-blinds-horiz' => esc_html__('Blinds Horizontal', 'et_builder'),
					'dzhvr-blinds-vert' => esc_html__('Blinds Vertical', 'et_builder'),
					'dzhvr-blinds-up' => esc_html__('Blinds Up', 'et_builder'),
					'dzhvr-blinds-down' => esc_html__('Blinds Down', 'et_builder'),
					'dzhvr-blinds-left' => esc_html__('Blinds Left', 'et_builder'),
					'dzhvr-blinds-right' => esc_html__('Blinds Right', 'et_builder'),
					'dzhvr-border-reveal-vert' => esc_html__('Border Reveal Vertical', 'et_builder'),
					'dzhvr-border-reveal-horiz' => esc_html__('Border Reveal Horizontal', 'et_builder'),
					'dzhvr-border-reveal-corners-1' => esc_html__('Border Reveal Corners 1', 'et_builder'),
					'dzhvr-border-reveal-corners-2' => esc_html__('Border Reveal Corners 2', 'et_builder'),
					'dzhvr-border-reveal-top-left' => esc_html__('Border Reveal Top Left', 'et_builder'),
					'dzhvr-border-reveal-top-right' => esc_html__('Border Reveal Top Right', 'et_builder'),
					'dzhvr-border-reveal-bottom-left' => esc_html__('Border Reveal Bottom Left', 'et_builder'),
					'dzhvr-border-reveal-bottom-right' => esc_html__('Border Reveal Bottom Right', 'et_builder'),
					'dzhvr-border-reveal-cc-1' => esc_html__('Border Reveal CC 1', 'et_builder'),
					'dzhvr-border-reveal-ccc-1' => esc_html__('Border Reveal CCC 1', 'et_builder'),
					'dzhvr-border-reveal-cc-2' => esc_html__('Border Reveal CC 2', 'et_builder'),
					'dzhvr-border-reveal-cc-3' => esc_html__('Border Reveal CC 3', 'et_builder'),
					'dzhvr-border-reveal-ccc-3' => esc_html__('Border Reveal CCC 3', 'et_builder'),
					'dzhvr-image-zoom-center' => esc_html__('Image Zoom Center', 'et_builder'),
					'dzhvr-image-zoom-out' => esc_html__('Image Zoom Out', 'et_builder'),
					'dzhvr-image-rotate-left' => esc_html__('Image Rotate Left', 'et_builder'),
					'dzhvr-image-rotate-right' => esc_html__('Image Rotate Right', 'et_builder'),
					'dzhvr-book-open-horiz' => esc_html__('Book Open Horizontal', 'et_builder'),
					'dzhvr-book-open-vert' => esc_html__('Book Open Vertical', 'et_builder'),
					'dzhvr-book-open-up' => esc_html__('Book Open Up', 'et_builder'),
					'dzhvr-book-open-down' => esc_html__('Book Open Down', 'et_builder'),
					'dzhvr-book-open-left' => esc_html__('Book Open Left', 'et_builder'),
					'dzhvr-book-open-right' => esc_html__('Book Open Right', 'et_builder'),
					'dzhvr-circle-up' => esc_html__('Circle Up', 'et_builder'),
					'dzhvr-circle-down' => esc_html__('Circle Down', 'et_builder'),
					'dzhvr-circle-left' => esc_html__('Circle Left', 'et_builder'),
					'dzhvr-circle-right' => esc_html__('Circle Right', 'et_builder'),
					'dzhvr-circle-top-left' => esc_html__('Circle Top Left', 'et_builder'),
					'dzhvr-circle-top-right' => esc_html__('Circle Top Right', 'et_builder'),
					'dzhvr-circle-bottom-left' => esc_html__('Circle Bottom Left', 'et_builder'),
					'dzhvr-circle-bottom-right' => esc_html__('Circle Bottom Right', 'et_builder'),
					'dzhvr-shift-top-left' => esc_html__('Shift Top Left', 'et_builder'),
					'dzhvr-shift-top-right' => esc_html__('Shift Top Right', 'et_builder'),
					'dzhvr-shift-bottom-left' => esc_html__('Shift Bottom Left', 'et_builder'),
					'dzhvr-shift-bottom-right' => esc_html__('Shift Bottom Right', 'et_builder'),
					'dzhvr-bounce-in' => esc_html__('Bounce In', 'et_builder'),
					'dzhvr-bounce-in-up' => esc_html__('Bounce In Up', 'et_builder'),
					'dzhvr-bounce-in-down' => esc_html__('Bounce In Down', 'et_builder'),
					'dzhvr-bounce-in-left' => esc_html__('Bounce In Left', 'et_builder'),
					'dzhvr-bounce-in-right' => esc_html__('Bounce In Right', 'et_builder'),
					'dzhvr-bounce-out' => esc_html__('Bounce Out', 'et_builder'),
					'dzhvr-bounce-out-up' => esc_html__('Bounce Out Up', 'et_builder'),
					'dzhvr-bounce-out-down' => esc_html__('Bounce Out Down', 'et_builder'),
					'dzhvr-bounce-out-left' => esc_html__('Bounce Out Left', 'et_builder'),
					'dzhvr-bounce-out-right' => esc_html__('Bounce Out Right', 'et_builder'),
					'dzhvr-fall-away-horiz' => esc_html__('Fall Away Horizontal', 'et_builder'),
					'dzhvr-fall-away-vert' => esc_html__('Fall Away vertical', 'et_builder'),
					'dzhvr-fall-away-cc' => esc_html__('Fall Away CC', 'et_builder'),
					'dzhvr-fall-away-ccc' => esc_html__('Fall Away CCC', 'et_builder'),
					'dzhvr-modal-slide-up' => esc_html__('Modal Slide Up', 'et_builder'),
					'dzhvr-modal-slide-down' => esc_html__('Modal Slide Down', 'et_builder'),
					'dzhvr-modal-slide-left' => esc_html__('Modal Slide Left', 'et_builder'),
					'dzhvr-modal-slide-right' => esc_html__('Modal Slide Right', 'et_builder'),
					'dzhvr-modal-hinge-up' => esc_html__('Modal Hinge Up', 'et_builder'),
					'dzhvr-modal-hinge-down' => esc_html__('Modal Hinge Down', 'et_builder'),
					'dzhvr-modal-hinge-left' => esc_html__('Modal Hinge Left', 'et_builder'),
					'dzhvr-modal-hinge-right' => esc_html__('Modal Hinge Right', 'et_builder'),
					'dzhvr-lightspeed-in-left' => esc_html__('Lightspeed In Left', 'et_builder'),
					'dzhvr-lightspeed-in-right' => esc_html__('Lightspeed In Right', 'et_builder'),
					'dzhvr-lightspeed-out-left' => esc_html__('Lightspeed Out Left', 'et_builder'),
					'dzhvr-lightspeed-out-right' => esc_html__('Lightspeed Out Right', 'et_builder'),
					'dzhvr-grad-radial-in' => esc_html__('Grad Radial In', 'et_builder'),
					'dzhvr-grad-radial-out' => esc_html__('Grad Radial Out', 'et_builder'),
					'dzhvr-grad-up' => esc_html__('Grad Up', 'et_builder'),
					'dzhvr-grad-down' => esc_html__('Grad Down', 'et_builder'),
					'dzhvr-grad-left' => esc_html__('Grad Left', 'et_builder'),
					'dzhvr-grad-right' => esc_html__('Grad Right', 'et_builder'),
					'dzhvr-grad-top-left' => esc_html__('Grad Top Left', 'et_builder'),
					'dzhvr-grad-top-right' => esc_html__('Grad Top Right', 'et_builder'),
					'dzhvr-grad-bottom-left' => esc_html__('Grad Bottom Left', 'et_builder'),
					'dzhvr-grad-bottom-right' => esc_html__('Grad Bottom Right', 'et_builder'),
					'dzhvr-parallax-up' => esc_html__('Parallax Up', 'et_builder'),
					'dzhvr-parallax-down' => esc_html__('Parallax Down', 'et_builder'),
					'dzhvr-parallax-left' => esc_html__('Parallax Left', 'et_builder'),
					'dzhvr-parallax-right' => esc_html__('Parallax Right', 'et_builder'),
					'dzhvr-stack-up' => esc_html__('Stack Up', 'et_builder'),
					'dzhvr-stack-down' => esc_html__('Stack Down', 'et_builder'),
					'dzhvr-stack-left' => esc_html__('Stack Left', 'et_builder'),
					'dzhvr-stack-right' => esc_html__('Stack Right', 'et_builder'),
					'dzhvr-stack-top-left' => esc_html__('Stack Top Left', 'et_builder'),
					'dzhvr-stack-top-right' => esc_html__('Stack Top Right', 'et_builder'),
					'dzhvr-stack-bottom-left' => esc_html__('Stack Bottom Left', 'et_builder'),
					'dzhvr-stack-bottom-right' => esc_html__('Stack Bottom Right', 'et_builder'),
					'dzhvr-cube-up' => esc_html__('Cube Up', 'et_builder'),
					'dzhvr-cube-down' => esc_html__('Cube Down', 'et_builder'),
					'dzhvr-cube-left' => esc_html__('Cube Left', 'et_builder'),
					'dzhvr-cube-right' => esc_html__('Cube Right', 'et_builder'),
					'dzhvr-dive' => esc_html__('Dive', 'et_builder'),
					'dzhvr-dive-cc' => esc_html__('Dive CC', 'et_builder'),
					'dzhvr-dive-ccc' => esc_html__('Dive CCC', 'et_builder'),
					'dzhvr-splash-up' => esc_html__('Splash Up', 'et_builder'),
					'dzhvr-splash-down' => esc_html__('Splash Down', 'et_builder'),
					'dzhvr-splash-left' => esc_html__('Splash Left', 'et_builder'),
					'dzhvr-splash-right' => esc_html__('Splash Right', 'et_builder'),
					'dzhvr-switch-up' => esc_html__('Switch Up', 'et_builder'),
					'dzhvr-switch-down' => esc_html__('Switch Down', 'et_builder'),
					'dzhvr-switch-left' => esc_html__('Switch Left', 'et_builder'),
					'dzhvr-switch-right' => esc_html__('Switch Right', 'et_builder'),
					'dzhvr-flash-top-left' => esc_html__('Flash Top Left', 'et_builder'),
					'dzhvr-flash-top-right' => esc_html__('Flash Top Right', 'et_builder'),
					'dzhvr-flash-bottom-left' => esc_html__('Flash Bottom Left', 'et_builder'),
					'dzhvr-flash-bottom-right' => esc_html__('Flash Bottom Right', 'et_builder'),
				),
				'toggle_slug'     => 'effect',
				'tab_slug'          => 'advanced',
				'description'     => esc_html__('Advanced Image hover style', 'et_builder'),
				'show_if' => array(
					'effect_style' => 'adv',
					'swap' => 'off'
				)
			),
			'minimal_style' => array(
				'default'         => 'minimal-effect-1',
				'label'           => esc_html__('Minimal Hover Style', 'et_builder'),
				'type'            => 'select',
				'options'         => array(
					'minimal-effect-1' => esc_html__('Effect 1', 'et_builder'),
					'minimal-effect-2' => esc_html__('Effect 2', 'et_builder'),
					'minimal-effect-3' => esc_html__('Effect 3', 'et_builder'),
					'minimal-effect-4' => esc_html__('Effect 4', 'et_builder'),
					'minimal-effect-5' => esc_html__('Effect 5', 'et_builder'),
					'minimal-effect-6' => esc_html__('Effect 6', 'et_builder'),
					
				),
				'toggle_slug'     => 'effect',
				'tab_slug'          => 'advanced',
				'description'     => esc_html__('Minimal Image hover style', 'et_builder'),
				'show_if' => array(
					'effect_style' => 'minimal',
					'swap' => 'off'
				)
			),
		);
		$image = array(
			'image' => array(
				'label'					=> esc_html__('Upload Image', 'et_builder'),
				'type'               	=> 'upload',
				'upload_button_text' 	=> esc_attr__('Upload an image', 'et_builder'),
				'choose_text'        	=> esc_attr__('Choose an Image', 'et_builder'),
				'update_text'        	=> esc_attr__('Set As Image', 'et_builder'),
				'toggle_slug'        	=> 'content'
			),
			'image_alt' => array(
				'label'					=> esc_html__('Image alt text', 'et_builder'),
				'type'               	=> 'text',
				'option_category' 		=> 'basic_option',
				'description'     		=> esc_html__('Insert the Image alt text.', 'et_builder'),
				'toggle_slug'     		=> 'content',
				'show_if'	=> array(
					'image_as_bg'	=> 'off'
				)
			),
			'image_as_bg' => array(
				'label'					=> esc_html__('Image as Background', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'description'     		=> esc_html__('Some hover effects are not working if you are enable this.', 'et_builder'),
				'option_category' 		=> 'basic_option',
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'content',
				'default'				=> 'off',
				'show_if'	=> array(
					'swap'	=> 'off'
				)
			),
			'image_height_bg'	=> array(
				'label'					=> esc_html__('Image Height', 'et_builder'),
				'type'               	=> 'range',
				'option_category' 		=> 'basic_option',
				'description'     		=> esc_html__('Here you can manage image Height', 'et_builder'),
				'toggle_slug'     		=> 'content',
				'allowed_units'    		=> array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
				'default_unit'     		=> 'px',
				'default'         		=> '400',
				'mobile_options'		=> true,
				'range_settings' => array(
					'min'  		=> '0',
					'max'  		=> '800',
					'step' 		=> '1'
				),
				'show_if'	=> array(
					'image_as_bg'	=> 'on'
				)
			),
			
			'image_height_settings' => array(
				'label'					=> esc_html__('Image height', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'description'     		=> esc_html__('Image height.', 'et_builder'),
				'option_category' 		=> 'basic_option',
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'content',
				'default'				=> 'off',
				'show_if'	=> array(
					'image_as_bg'	=> 'off'
				)
			),
			'image_height'	=> array(
				'label'					=> esc_html__('Image Height', 'et_builder'),
				'type'               	=> 'range',
				'option_category' 		=> 'basic_option',
				'description'     		=> esc_html__('Here you can manage image Height', 'et_builder'),
				'toggle_slug'     		=> 'content',
				'allowed_units'    		=> array( '%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw' ),
				'default'          		=> '400',
				'default_unit'     		=> 'px',
				'default_on_front' 		=> '',
				'mobile_options'		=> true,
				'range_settings' => array(
					'min'  		=> '0',
					'max'  		=> '1200',
					'step' 		=> '1'
				),
				'show_if'	=> array(
					'image_as_bg'	=> 'off',
					'image_height_settings' => 'on'
				)
			),
			
			'image_opacity' => array(
				'label'					=> esc_html__('Image Opacity', 'et_builder'),
				'type'               	=> 'range',
				'option_category' 		=> 'basic_option',
				'description'     		=> esc_html__('Here you can manage image opacity level', 'et_builder'),
				'toggle_slug'     		=> 'content',
				'allowed_units'    		=> array( '' ),
				'default_unit'     		=> '',
				'default'         		=> '1',
				'default_on_front' 		=> '1',
				'hover'					=> 'tabs',
				'range_settings' => array(
					'min'  		=> '0',
					'max'  		=> '1',
					'step' 		=> '0.1'
				),
				'show_if'	=> array(
					'image_as_bg'	=> 'off'
				),
			)
		);

		$swap_image = array(
			'swap' => array(
				'label'					=> esc_html__('Swap Effect', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'option_category' 		=> 'basic_option',
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'swap_image',
				'default'				=> 'off',
				'show_if'	=> array(
					'image_as_bg'	=> 'off'
				)
			),
			'swap_effect' => array(
				'default'		=> 'dih_swap_fade',
				'label'			=> esc_html__('Swap Image Effect Style', 'et_builder'),
				'type'			=> 'select',
				'options'		=> array(
					'dih_swap_fade'	=> esc_html__('Fade', 'et_builder'),
					'dih_swap_zoom' => esc_html__('Zoom', 'et_builder'),
					'dih_swap_push_up' => esc_html__('Push Up', 'et_builder'),
					'dih_swap_push_left' => esc_html__('Push Left', 'et_builder'),
					'dih_swap_blur' => esc_html__('Blur', 'et_builder'),
				),
				'toggle_slug'	=> 'swap_image',
				'show_if' => array(
					'swap' => 'on'
				)
			),
			'swap_image' => array(
				'label'					=> esc_html__('Backend Image', 'et_builder'),
				'type'               	=> 'upload',
				'upload_button_text' 	=> esc_attr__('Upload an image', 'et_builder'),
				'choose_text'        	=> esc_attr__('Choose an Image', 'et_builder'),
				'update_text'        	=> esc_attr__('Set As Image', 'et_builder'),
				'toggle_slug'        	=> 'swap_image',
				'show_if' => array(
					'swap' => 'on'
				)
			),
			'swap_img_alt' => array(
				'label'					=> esc_html__('Image alt text', 'et_builder'),
				'type'               	=> 'text',
				'option_category' 		=> 'basic_option',
				'description'     		=> esc_html__('Insert the Image alt text.', 'et_builder'),
				'toggle_slug'     		=> 'swap_image',
				'show_if' => array(
					'swap' => 'on'
				)
			),

		);

		$title = array(
			't_prefix' => array(
				'label'					=> esc_html__('Title Prefix', 'et_builder'),
				'type'					=> 'text',
				'option_category'		=> 'basic_option',
				'description'			=> esc_html__('Title Prefix', 'et_builder'),
				'toggle_slug'			=> 'content',
				'show_if' => array(
					'swap' => 'off'
				)
			),
			't_infix' => array(
				'label'					=> esc_html__('Title Infix', 'et_builder'),
				'type'					=> 'text',
				'option_category'		=> 'basic_option',
				'description'			=> esc_html__('Title Infix', 'et_builder'),
				'toggle_slug'			=> 'content',
				'show_if' => array(
					'swap' => 'off'
				)
			),
			't_suffix' => array(
				'label'					=> esc_html__('Title Suffix', 'et_builder'),
				'type'					=> 'text',
				'option_category'		=> 'basic_option',
				'description'			=> esc_html__('Title Suffix', 'et_builder'),
				'toggle_slug'			=> 'content',
				'show_if' => array(
					'swap' => 'off'
				)
			)
		);
		$content = array(
			'content_text' => array(
				'label'             => esc_html__('Content', 'et_builder'),
				'type'              => 'tiny_mce',
				'option_category'   => 'basic_option',
				'description'       => esc_html__('Input the main text content for your module here.', 'et_builder'),
				'toggle_slug'       => 'content',
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				)
			),
			'content_text_hidden_in_mobile' => array(
				'label'					=> esc_html__('Content Text Hide in Mobile', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'option_category' 		=> 'basic_option',
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'content',
				'default'				=> 'off',
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				)
			),	
		);
		$button = array(
			'button_text' => array(
				'label'           => esc_html__('Button Text', 'et_builder'),
				'type'            => 'text',
				'option_category' => 'basic_option',
				'description'     => esc_html__('Input your desired button text, or leave blank for no button.', 'et_builder'),
				'toggle_slug'     => 'content',
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				)
			),
			'button_url' => array(
				'label'           => esc_html__('Button URL', 'et_builder'),
				'type'            => 'text',
				'data_type'		=> 'url',
				'option_category' => 'basic_option',
				'description'     => esc_html__('Input URL for your button.', 'et_builder'),
				'toggle_slug'     => 'content',
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				),
				'dynamic_content' => 'url'
			),
			'button_url_new_window' => array(
				'default'         => 'off',
				'default_on_front' => true,
				'label'           => esc_html__('Url Opens', 'et_builder'),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__('In The Same Window', 'et_builder'),
					'on'  => esc_html__('In The New Tab', 'et_builder'),
				),
				'toggle_slug'     => 'content',
				'description'     => esc_html__('Choose whether your link opens in a new window or not', 'et_builder'),
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				)
			),
			'button_alignment' => array(
				'label'				=> esc_html__('Button Alignment', 'et_builder'),
				'type'				=> 'align',
				'option_category'	=> 'layout',
				'options'			=> et_builder_get_text_orientation_options( array( 'justified' ) ),
				'toggle_slug'		=> 'content',
				'default'			=> 'center',
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				)
			)	
		);
		$link = array(
			'module_link_url' => array(
				'label'           => esc_html__('Module Link URL', 'et_builder'),
				'type'            => 'text',
				'data_type'		=> 'url',
				'option_category' => 'basic_option',
				'description'     => esc_html__('When cliked the module will link to this URL.', 'et_builder'),
				'toggle_slug'     => 'link',
				'dynamic_content' => 'url'
			),
			'module_link_url_new_window' => array(
				'default'         => 'off',
				'default_on_front' => true,
				'label'           => esc_html__('Module Link Target', 'et_builder'),
				'type'            => 'select',
				'option_category' => 'configuration',
				'options'         => array(
					'off' => esc_html__('In The Same Window', 'et_builder'),
					'on'  => esc_html__('In The New Tab', 'et_builder'),
				),
				'toggle_slug'     => 'link',
				'description'     => esc_html__('Choose whether your link opens in a new window or not', 'et_builder')
			),
		);
		//Background

		$title_background = $this->dz_add_field(array(
			'label'             => 'Title Background',
			'key'               => 'title_background',
			'toggle_slug'       => 'title',
			'tab_slug'          => 'advanced',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$text_background = $this->dz_add_field(array(
			'label'             => 'Text Background',
			'key'               => 'text_background',
			'toggle_slug'       => 'content',
			'tab_slug'          => 'advanced',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$prefix_background = $this->dz_add_field(array(
			'label'             => 'Prefix Background',
			'key'               => 'prefix_background',
			'toggle_slug'       => 'title_prefix',
			'tab_slug'          => 'advanced',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$infix_background = $this->dz_add_field(array(
			'label'             => 'Infix Background',
			'key'               => 'infix_background',
			'toggle_slug'       => 'title_infix',
			'tab_slug'          => 'advanced',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$suffix_background = $this->dz_add_field(array(
			'label'             => 'Suffix Background',
			'key'               => 'suffix_background',
			'toggle_slug'       => 'title_suffix',
			'tab_slug'          => 'advanced',
			'show_if' => array(
				'swap' => 'off'
			)
		));

		//Spacing
		$title_spacing = $this->add_margin_padding(array(
			'title'             => 'Title',
			'key'               => 'title',
			'toggle_slug'       => 'custom_spacing',
			'sub_toggle'		=> 'title'
		));
		$prefix_spacing = $this->add_margin_padding(array(
			'title'             => 'Prefix',
			'key'               => 'prefix',
			'toggle_slug'       => 'custom_spacing',
			'sub_toggle'		=> 'title',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$infix_spacing = $this->add_margin_padding(array(
			'title'             => 'Infix',
			'key'               => 'infix',
			'toggle_slug'       => 'custom_spacing',
			'sub_toggle'		=> 'title',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$suffix_spacing = $this->add_margin_padding(array(
			'title'             => 'Suffix',
			'key'               => 'suffix',
			'toggle_slug'       => 'custom_spacing',
			'sub_toggle'		=> 'title',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$text_spacing = $this->add_margin_padding(array(
			'title'             => 'Text',
			'key'               => 'text',
			'toggle_slug'       => 'custom_spacing',
			'sub_toggle'		=> 'text',
			'show_if' => array(
				'swap' => 'off'
			)
		));
		$content_wrapper_spacing = $this->add_margin_padding(array(
			'title'             => 'Content Wrapper',
			'key'               => 'content_wrapper',
			'option'			=> 'padding',
			'toggle_slug'       => 'custom_spacing',
			'sub_toggle'		=> 'container',
			'show_if' => array(
				'swap' => 'off'
			)
		));


		$imageOverlay = $this->dz_add_field(array(
			'label'             => 'Image Overlay',
			'key'               => 'overlay',
			'toggle_slug'       => 'image_overlay',
			'show_if_not'	=> array(
				'effect_style' => 'modern',
				'effect_style' => 'minimal'
			),
			'show_if' => array(
				'swap' => 'off'
				
			)
		));
		// Modern Image overlay
		$modernEffect_image_overlay = array(
			'modern_overlay_color' => array(
				'label' 			=> esc_html__('Image Overlay Color', 'et_builder'),
				'type'              => 'color-alpha',
				'option_category'	=> 'basic_option',
				'toggle_slug'       => 'image_overlay',
				'hover'				=> 'tabs',
				'show_if' => array(
					'swap' => 'off',
					'effect_style' => 'modern'
				)
			),
		);

		$vertical_align = array(
			'content_valign' => array(
				'label'					=> esc_html__('Vertical Align Center', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'option_category' 		=> 'basic_option',
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'content',
				'default'				=> 'off',
				'show_if' => array(
					'swap' => 'off',
					'image_lightbox' => 'off'
				)
			),
		);

		$Gradient_color = array(
			'grad_color_1'	=>array(
				'default'			=> '#ff0057',
				'label' 			=> esc_html__('Gradient Color 1', 'et_builder'),
				'type'              => 'color-alpha',
				'option_category'	=> 'basic_option',
				'toggle_slug'       => 'effect',
				'tab_slug'			=> 'advanced',
				'show_if' => array(
					'effect_style' => 'minimal',
					'minimal_style'=> 'minimal-effect-2'
				)
			),
			'grad_color_2'	=>array(
				'default'			=> '#e64a19',
				'label' 			=> esc_html__('Gradient Color 2', 'et_builder'),
				'type'              => 'color-alpha',
				'option_category'	=> 'basic_option',
				'toggle_slug'       => 'effect',
				'tab_slug'			=> 'advanced',
				'show_if' => array(
					'effect_style' => 'minimal',
					'minimal_style'=> 'minimal-effect-2'
				)
			),
			'minimal_effect_color_overlay' =>array(
				'label' 			=> esc_html__('Half Overlay Color', 'et_builder'),
				'type'              => 'color-alpha',
				'option_category'	=> 'basic_option',
				'toggle_slug'       => 'effect',
				'tab_slug'			=> 'advanced',
				'show_if' => array(
					'effect_style' => 'minimal',
					'minimal_style'=> 'minimal-effect-2'
				)
			),
		);
		$image_lightbox = array(
			'image_lightbox' => array(
				'label'					=> esc_html__('Image lightbox', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'option_category' 		=> 'basic_option',
				'description'			=> esc_html__('Enable Image Lightbox. Image lightbox do not allow title and content text','et_builder'),
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'lightbox',
				'default'				=> 'off',
				'show_if'	=> array(
					'image_as_bg'	=> 'off'
				)
			),
			'lightbox_text' => array(
				'label'					=> esc_html__('Data Lightbox', 'et_builder'),
				'type'					=> 'text',
				'option_category'		=> 'basic_option',
				'description'			=> esc_html__('Use Same Data lightbox name for the many image show as lightbox altogether', 'et_builder'),
				'toggle_slug'			=> 'lightbox',
				'show_if'	=> array(
					'image_lightbox'	=> 'on'
				)
			),
			'lightbox_image_overlay' =>array(
				'default'			=> 'rgba(0,0,0,.3)',
				'label' 			=> esc_html__('Image Lightbox Overlay Color', 'et_builder'),
				'type'              => 'color-alpha',
				'option_category'	=> 'basic_option',
				'hover'				=> 'tabs',
				'toggle_slug'       => 'lightbox',
				'show_if'	=> array(
					'image_lightbox'	=> 'on'
				)
			),
			'icon_settings'	=> array(
				'label'					=> esc_html__("Icon", 'et_builder'),
				'type'					=> 'yes_no_button',
				'options'				=> array(
					'off'				=> esc_html__('NO', 'et_builder'),
					'on'				=> esc_html__('Yes', 'et_builder'),
				),
				'option_category'		=> 'basic_option',
				'toggle_slug'			=> 'lightbox',
				'default_on_front'		=> 'off',
				'show_if'	=> array(
					'image_lightbox'	=> 'on'
				)
			),
			'icon' => array(
				'default'				=> '1',
				'label'					=> esc_html__('Choose an Icon', 'et_builder'),
				'type'					=> 'select_icon',
				'class'					=> array('et-pb-font-icon'),
				'toggle_slug'			=> 'lightbox',
				'option_category'		=> 'basic_option',
				'show_if'				=> array(
					'icon_settings'		=> 'on',
					'image_lightbox'	=> 'on'
				),
			),
			'icon_font_size' => array(
				'default'			=> '32px',
				'label'           	=> esc_html__('Icon Font Size', 'et_builder'),
				'description'     	=> esc_html__('Control the size of the icon by increasing or decreasing the font size.', 'et_builder'),
				'type'            	=> 'range',
				'option_category' 	=> 'font_option',
				'toggle_slug'     	=> 'lightbox',
				'default_unit'    	=> 'px',
				'allowed_units'   	=> array('%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'),
				'range_settings' => array(
					'min'  			=> '1',
					'max'  			=> '120',
					'step' 			=> '1',
				),
				'mobile_options'  	=> true,
				'responsive'      	=> true,
				'hover'           	=> 'tabs',
				'show_if'	=> array(
					'icon_settings'	=> 'on',
					'image_lightbox'	=> 'on'
				)
			),
			'icon_color'	=> array(
				'default'			=> '#fff',
				'label'				=> esc_html__('Icon Color', 'et_builder'),
				'type'				=> 'color-alpha',
				'options_category'	=> 'basic_option',
				'toggle_slug'		=> 'lightbox',
				'hover'				=> 'tabs',
				'show_if'	=> array(
					'icon_settings'	=> 'on',
					'image_lightbox'	=> 'on'
				)
			),

		);

		$content_show = array(
			'content_show' => array(
				'label'					=> esc_html__('Content show over the image', 'et_builder'),
				'type'               	=> 'yes_no_button',
				'option_category' 		=> 'basic_option',
				'description'			=> esc_html__('Content show over the image. This effect is experimental. Not works all hover effects.','et_builder'),
				'options'				=> array(
					'on'	=> esc_html__('Yes', 'et_builder'),
					'off'	=> esc_html__('No', 'et_builder')
				),
				'toggle_slug'        	=> 'content',
				'default'				=> 'off',
				'show_if'	=> array(
					'effect_style'	=> array('classic','adv')
				),
			),
		);

		$fields = array_merge(
			$image,
			$swap_image,
			$effect,
			$title,
			$content,
			$button,
			$vertical_align,
			$title_background,
			$text_background,
			$imageOverlay,
			$modernEffect_image_overlay,
			$title_spacing,
			$prefix_spacing,
			$infix_spacing,
			$suffix_spacing,
			$text_spacing,
			$content_wrapper_spacing,
			$prefix_background,
			$infix_background,
			$suffix_background,
			$image_lightbox,
			$link,
			$Gradient_color,
			$content_show

		);
		return $fields;
	}

	public function additional_css_styles($render_slug)
	{
		$utl = 'DZutilites';
		//Title Background
		if ($this->props['t_prefix'] !== '' || $this->props['t_infix'] !== '' || $this->props['t_suffix'] !== '') {
			$this->dz_process_background(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'title_background',
				'selector'          => '%%order_class%% .dih_img_wrapper .dih_title',
				'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title'
			));
		}

		//Text Background
		if ($this->props['content_text'] !== '') {
			$this->dz_process_background(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'text_background',
				'selector'          => '%%order_class%% .dih_img_wrapper .dih_text',
				'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_text'
			));
		}
		//Prefix Background
		if ($this->props['t_prefix'] !== '') {
			$this->dz_process_background(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'prefix_background',
				'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .prefix',
				'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .prefix'
			));
		}

		//Infix Background
		if ($this->props['t_infix'] !== '') {
			$this->dz_process_background(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'infix_background',
				'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .infix',
				'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .infix'
			));
		}

		//Suffix Background
		if ($this->props['t_suffix'] !== '') {
			$this->dz_process_background(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'suffix_background',
				'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .suffix',
				'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .suffix'
			));
		}

		//Title Spacing
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'title_margin',
			'type'              => 'margin',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title',
			'important'         => true
		));
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'title_padding',
			'type'              => 'padding',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title',
			'important'         => true
		));
		// prefix spacing
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'prefix_margin',
			'type'              => 'margin',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .prefix',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .prefix',
			'important'         => true
		));
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'prefix_padding',
			'type'              => 'padding',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .prefix',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .prefix',
			'important'         => true
		));
		// infix spacing
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'infix_margin',
			'type'              => 'margin',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .infix',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .infix',
			'important'         => true
		));
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'infix_padding',
			'type'              => 'padding',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .infix',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .infix',
			'important'         => true
		));
		// suffix spacing
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'suffix_margin',
			'type'              => 'margin',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .suffix',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .suffix',
			'important'         => true
		));
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'suffix_padding',
			'type'              => 'padding',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_title .suffix',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_title .suffix',
			'important'         => true
		));
		//Text Spacing
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'text_margin',
			'type'              => 'margin',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_text',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_text',
			'important'         => true
		));
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'text_padding',
			'type'              => 'padding',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_text',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_text',
			'important'         => true
		));
		$this->set_margin_padding_styles(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'content_wrapper_padding',
			'type'              => 'padding',
			'selector'          => '%%order_class%% .dih_img_wrapper .dih_content_wrapper',
			'hover'             => '%%order_class%% .dih_img_wrapper:hover .dih_content_wrapper',
			'important'         => true
		));
		//Image Overlay
		if ($this->props['swap'] === 'off' && $this->props['effect_style'] !== 'modern') {
			$this->dz_content_wrapper_background(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'overlay',
				'selector'          => "%%order_class%% .dih_img_wrapper.default,%%order_class%% .dih_img_wrapper.classic_style,%%order_class%% .dih_img_wrapper.advanced_style,%%order_class%% .dih_img_wrapper.minimal_style",
				'hover'          	=> "%%order_class%% .dih_img_wrapper.default:hover,%%order_class%% .dih_img_wrapper.classic_style:hover,%%order_class%% .dih_img_wrapper.advanced_style:hover,%%order_class%% .dih_img_wrapper.minimal_style:hover",
			));
		}

		//Modern Image Overlay Color
		if ($this->props['swap'] === 'off' && $this->props['effect_style'] === 'modern') {
			$this->dz_process_color(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'modern_overlay_color',
				'type'              => 'background-color',
				'selector'          => '%%order_class%% .dih_img_wrapper.modern_style .modern_img_overlay',
				'hover'             => '%%order_class%% .dih_img_wrapper.modern_style:hover .modern_img_overlay'
			));
		}


//Content Show over the image
if ($this->props['content_show'] == 'on' && ($this->props['effect_style']=='classic' || $this->props['effect_style']=='adv')) {
	ET_Builder_Element::set_style($render_slug, array(
		'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper',
		'declaration' => sprintf('opacity: %1$s!important;', '1'),
	));
}
if ($this->props['content_show'] == 'on' && ($this->props['effect_style']=='classic' || $this->props['effect_style']=='adv')) {
	ET_Builder_Element::set_style($render_slug, array(
		'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_content',
		'declaration' => sprintf('opacity: %1$s!important;', '1'),
	));
}

		//Image Opacity
		$image_opacity = $this->props['image_opacity'];
		$image_opacity = explode('px',$image_opacity);
		// echo $image_opacity. "<br>";
		if ($this->props['image_opacity'] !== '') {
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper .dih_image',
				'declaration' => sprintf('opacity: %1$s!important;', $image_opacity[0]),
			));
		}
		if (et_builder_is_hover_enabled('image_opacity', $this->props) && isset($this->props['image_opacity' . '__hover'])) {
			$image_opacity_hover_value = $this->props['image_opacity' . '__hover'];
			if (!empty($image_opacity_hover_value)) {
				ET_Builder_Element::set_style($render_slug, array(
					'selector' => '%%order_class%% .dih_img_wrapper:hover .dih_image',
					'declaration' => sprintf('opacity:%1$s!important;', $image_opacity_hover_value),
				));
			}
		}

		// Image wrapper image background in mobile or tablet device;
		if ($this->props['swap'] === 'off') {
			$this->add_classname('dizo_bg_img');
		}
		//Image as Background
		if($this->props['image'] !=='' && $this->props['image_as_bg'] === 'on' && $this->props['swap'] === 'off'){
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%%.dizo_bg_img .dih_img_wrapper',
				'declaration' => sprintf(
					'background: url(%1$s)!important;background-size:cover!important;
					background-position:center!important; min-height:300px; width:100%2$s;',
					$this->props['image'],
					'%'
				),
			));
			//Background image height
			$this->apply_single_value(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'image_height_bg',
				'type'              => 'height',
				'selector'          => '%%order_class%%.dizo_bg_img .dih_img_wrapper ',
				'unit'              => 'px',
				'hover'             => '',
				'default'			=> '400'
			));
		}
		//	Image height
		if($this->props['image'] !=='' && $this->props['image_as_bg'] === 'off' && $this->props['image_height_settings'] ==='on'){
			$this->apply_single_value(array(
				'module'            => $this,
				'render_slug'       => $render_slug,
				'slug'              => 'image_height',
				'type'              => 'height',
				'selector'          => '%%order_class%% .dih_img_wrapper .dih_image img ',
				'unit'              => 'px',
				'hover'             => '',
				'default'			=> '400px',
				'important'			=> true
			));
		}

		//Vertical Align Center
		if ($this->props['modern_style'] !== 'mdn-susan' && $this->props['content_valign'] === 'on') {
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper',
				'declaration' => 'display:flex;justify-content:center;align-items:center;',
				// 'declaration' => 'position:relative!important;top:50%!important;transform:translateY(-50%)!important;',
				// 'media_query' => ET_Builder_Element::get_media_query('min_width_981')
			));
		}

		
		//Minimal Effect Color
		if($this->props['effect_style'] === 'minimal' && $this->props['minimal_style'] === 'minimal-effect-2' ){
			if($this->props['grad_color_1'] !=='' && $this->props['grad_color_2'] !==''){
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper.minimal_style.minimal-effect-2:before',
				'declaration' => sprintf('background-image: linear-gradient(315deg, %1$s, %2$s)!important;',$this->props['grad_color_2'],$this->props['grad_color_1'])
		));
			}
	}
	if($this->props['minimal_effect_color_overlay'] !==''){
		ET_Builder_Element::set_style($render_slug, array(
			'selector' => '%%order_class%% .dih_img_wrapper.minimal_style.minimal-effect-2:after',
			'declaration' => sprintf(
				'background-color:%1$s; content:""; position:absolute;top:0px;right:0;bottom:0;width:%2$s;z-index:1;', 
				$this->props['minimal_effect_color_overlay'], "50%" )
		));
	}

	//Lightbox image overlay

	if ($this->props['image_lightbox'] === 'on' && $this->props['lightbox_image_overlay'] !== '') {
		$this->dz_process_color(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'lightbox_image_overlay',
			'type'              => 'background-color',
			'selector'          => '%%order_class%%.dizo-lightbox .dih_img_wrapper .dih_lightbox_overlay',
			'hover'             => '%%order_class%%.dizo-lightbox .dih_img_wrapper:hover .dih_lightbox_overlay'
		)); 
	}

	//Icon Font size
	if ($this->props['image_lightbox'] === 'on' && $this->props['icon_settings'] === 'on' && $this->props['icon_font_size'] !== '') {
		$this->apply_single_value(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'icon_font_size',
			'selector'          => "%%order_class%%.dizo-lightbox .dih_img_wrapper .dih_image a .et-pb-icon",
			'unit'              => 'px',
			'hover'				=> "%%order_class%%.dizo-lightbox .dih_img_wrapper:hover .dih_image a .et-pb-icon",
			'type'              => 'font-size',
			'important'			=> true,
	
		));
	}
	//Icon Color
	if ($this->props['icon_color'] !== '') {
		$this->dz_process_color(array(
			'module'            => $this,
			'render_slug'       => $render_slug,
			'slug'              => 'icon_color',
			'type'              => 'color',
			'selector'          => "%%order_class%%.dizo-lightbox .dih_img_wrapper .dih_image a .et-pb-icon",
			'hover'             => "%%order_class%%.dizo-lightbox .dih_img_wrapper:hover .dih_image a .et-pb-icon",
			'important'         => true
		));
	}

	//Button Alignment
	$button_alignment = array(
		'left'		=> 'flex-start',
		'center'	=> 'center',
		'right'		=> 'flex-end'
	);
	if($this->props['button_alignment'] !==''){
		ET_Builder_Element::set_style($render_slug, array(
			'selector' => '%%order_class%% .dih_img_wrapper .et_pb_button_wrapper',
			'declaration' => sprintf(
				'justify-content:%1$s;', 
				$button_alignment[$this->props['button_alignment']] )
		));
	}

		// Custom Transition
			$this->apply_custom_transition(
				$this,
				$render_slug,
				'%%order_class%%, %%order_class%% *'
			);
	}
	public function render($attrs, $content = null, $render_slug)
	{
		$button_text           	= $this->props['button_text'];
		$button_url            	= $this->props['button_url'];
		$button_url_new_window 	= $this->props['button_url_new_window'];
		// Design related props are added via $this->advanced_options['button']['button']
		$button_custom         	= $this->props['custom_button'];
		$button_rel            	= $this->props['button_rel'];
		$button_use_icon       	= $this->props['button_icon'];
		$src					= $this->props['image'];
		$icon 					= html_entity_decode(et_pb_process_font_icon($this->props['icon']));

		// Render button
		$button = $this->render_button(array(
			'button_classname' => array(
				'dih_button'
			),
			'button_text'      => $button_text,
			'button_url'       => $button_url,
			'url_new_window'   => $button_url_new_window,
			'button_custom'    => $button_custom,
			'button_rel'       => $button_rel,
			'custom_icon'      => $button_use_icon,
			'has_wrapper'		=> true
		));
		$button_margin = $this->props['button_custom_margin'] !== '' ? $this->props['button_custom_margin'] : '';
		$button_margin_tablet = $this->props['button_custom_margin_tablet'] !== '' ?
			$this->props['button_custom_margin_tablet'] : $button_margin;
		$button_margin_phone = $this->props['button_custom_margin_phone'] !== '' ?
			$this->props['button_custom_margin_phone'] : $button_margin_tablet;
		if (isset($button_margin) && !empty($button_margin)) {
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .et_pb_button_wrapper',
				'declaration' => et_builder_get_element_style_css(
					$button_margin,
					'margin',
					'important'
				),
			));
		}
		if (isset($button_margin_tablet) && !empty($button_margin_tablet)) {
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .et_pb_button_wrapper',
				'declaration' => et_builder_get_element_style_css(
					$button_margin_tablet,
					'margin',
					'important'
				),
				'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
			));
		}
		if (isset($button_margin_phone) && !empty($button_margin_phone)) {
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .et_pb_button_wrapper',
				'declaration' => et_builder_get_element_style_css(
					$button_margin_phone,
					'margin',
					'important'
				),
				'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
			));
		}
		
		$t_prefix = $this->props['t_prefix'] !== '' ? sprintf('<span class = "prefix">%1$s</span>',$this->props['t_prefix']) : '';
		$t_infix = $this->props['t_infix'] !== '' ? sprintf('<span class = "infix">%1$s</span>',$this->props['t_infix']) : '';
		$t_suffix = $this->props['t_suffix'] !== '' ? sprintf('<span class = "suffix">%1$s</span>',$this->props['t_suffix']) : '';
		$heading = $this->props['title_level'];

		$title = !empty($t_prefix) || !empty($t_infix) || !empty($t_suffix)? sprintf(
			'<%4$s class = "dih_title">
			%1$s 
			%2$s 
			%3$s
			</%4$s>',
			$t_prefix,
			$t_infix,
			$t_suffix,
			et_pb_process_header_level($heading, 'h2')
		):'';


		$content = '' !== $this->props['content_text'] ?
			sprintf('%1$s', $this->props['content_text']) : '';

		// Content Text Hidden in mobile

	if ($this->props['content_text'] !=='' && $this->props['content_text_hidden_in_mobile'] === 'on') {
			ET_Builder_Element::set_style($render_slug, array(
				'selector' => '%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_text, 
							%%order_class%% .dih_img_wrapper .dih_content_wrapper .dih_text p',
				'declaration' => 'display:none!important;',
				'media_query' => ET_Builder_Element::get_media_query('max_width_767'),
			));
		}
	
		//Image 

		$data_lightbox = self::get_module_order_class( $render_slug );
		if($this->props['image_lightbox'] === 'on' && $this->props['lightbox_text'] !==''){
			$data_lightbox = $this->props['lightbox_text'];
		}
		
		if( $this->props['image_as_bg'] === 'off' && ''!== $this->props['image'] ){
			$image = $this->props['image'] !== '' ? sprintf(
				'<div class = "dih_image"><img src="%1$s" alt="%2$s"/></div>',
				esc_url($this->props['image']),
				$this->props['image_alt'] !== '' ? $this->props['image_alt'] : ''
			)  : '';
		}
		// Image Lightbox enable
		if($this->props['image'] !=='' && $this->props['image_as_bg'] === 'off' && $this->props['image_lightbox'] === 'on'){
			$this->add_classname('dizo-lightbox');
			$lightbox_text = sprintf('%1$s %2$s %3$s', $this->props['t_prefix'], $this->props['t_infix'], $this->props['t_suffix']);
			//icon enable
			$lightbox_overlay = $this->props['image_lightbox'] === 'on'? '<span class = "dih_lightbox_overlay"></span>':'';
			if($this->props['image_lightbox'] === 'on' && $this->props['icon_settings'] === 'on' && $this->props['icon'] !==''){
				$lightbox_overlay = sprintf('<span class = "et-pb-icon dih_lightbox_overlay">%1$s</span>', $icon );
			}
			
			$image = sprintf(
				'<div class = "dih_image"> 
				<a href ="%1$s" data-dzlightbox = "%4$s" data-title = "%3$s"><img src = "%1$s" alt = "%2$s"/>
				%5$s
				</a>
				
				</div>', 
				esc_url($this->props['image']), 
				$this->props['image_alt'] !== '' ? $this->props['image_alt'] : '',
				$lightbox_text,
				$data_lightbox,
				$lightbox_overlay
				
			);
		}

		//Modern image overlay
		$modern_image_overlay = $this->props['effect_style'] === 'modern' ? sprintf(
			'<span class ="%1$s"></span>',
			'modern_img_overlay'
		) : '';
		//Swap Image
		$swap_image = $this->props['swap'] === 'on' && $this->props['swap_image'] !== '' ? sprintf(
			'<div class = "dih_backend_image"><img src="%1$s" alt="%2$s"/></div>',
			$this->props['swap_image'],
			$this->props['swap_img_alt']
		)  : '';
		// Swap image when lightbox enable
		if($this->props['swap'] === 'on' && $this->props['swap_image'] !=='' && $this->props['image_lightbox'] ==='on'){
			$swap_image = sprintf(
				'<div class = "dih_backend_image">
				<a href ="%1$s" data-dzlightbox ="%3$s" data-title ="title">
				<img src="%1$s" alt="%2$s"/>
				</a>
				</div>',
				$this->props['swap_image'],
				$this->props['swap_img_alt'],
				$data_lightbox
			);
		}

		$classic_style = $this->props['effect_style'] == 'classic' ?
			'classic_style ' . $this->props['classic_style'] : '';

		$modern_style = $this->props['effect_style'] == 'modern' ?
			'modern_style ' . $this->props['modern_style'] : '';
		$advanced_style = $this->props['effect_style'] == 'adv' ?
			'advanced_style ' . $this->props['advanced_style'] : '';
		$minimal_style = $this->props['effect_style'] == 'minimal' ?
			'minimal_style ' . $this->props['minimal_style'] : '';

		$style_classes =  $this->props['effect_style'] !== 'default' ? sprintf(
			'%1$s%2$s%3$s%4$s',
			$classic_style ? $classic_style : '',
			$modern_style ? $modern_style : '',
			$advanced_style ? $advanced_style : '',
			$minimal_style? $minimal_style : ''
		) : 'default';

		$module_link = $this->props['module_link_url'] !== '' ? sprintf(
			'<a class= "dih_link" href="%1$s" %2$s></a>',
			$this->props['module_link_url'],
			$this->props['module_link_url_new_window'] == 'on' ? 'target=_blank' : ''
		) : '';

		$content_markup = $content !== '' || $this->props['button_url'] !==''? sprintf(
			'<div class ="dih_text">
			%1$s
			%2$s
			</div>', 
			et_core_esc_previously($content),
			$this->props['effect_style'] === 'modern'? et_core_sanitized_previously($button):''

		):'';
		$style_content = sprintf(
			'<div class = "dih_img_wrapper %1$s">
					%2$s
					%7$s
					%6$s
					<div class ="dih_content_wrapper">
						<div class = "dih_content">
						%3$s
						%4$s
						%5$s
						</div>
				</div>
				%8$s
			</div>',
			$style_classes,
			$this->props['image_as_bg'] === 'off'? (!empty($image)? $image:''):'',
			et_core_esc_previously($title),
			et_core_esc_previously($content_markup),
			$this->props['effect_style']!== 'modern'? et_core_sanitized_previously($button):'',
			$swap_image,
			$modern_image_overlay,
			$this->props['image_lightbox'] !== 'on' ? $module_link: ''
		
		);

		
		$this->additional_css_styles($render_slug);
		$swap_class = $this->props['swap'] === 'on' && $this->props['swap_effect'] !== '' ? 'dih_swap_image ' . $this->props['swap_effect'] : '';
		return sprintf(
			'<div class="dih_container %2$s">
				%1$s
			</div>',
			$style_content,
			$swap_class
		);
	}
	
}

new DIZO_ImageHover;
